/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.text;

import com.floragunn.codova.config.text.PatternImpl;
import com.floragunn.codova.config.text.SimplePatternImpl;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Pattern
extends Document<Pattern>,
Predicate<String> {
    public static Pattern create(String pattern) throws ConfigValidationException {
        if ("*".equals(pattern)) {
            return Pattern.wildcard();
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return new PatternImpl.JavaPattern(pattern.substring(1, pattern.length() - 1));
        }
        if (pattern.endsWith("*") && pattern.indexOf(42) == pattern.length() - 1 && !pattern.contains("?")) {
            return new PatternImpl.PrefixPattern(pattern.substring(0, pattern.length() - 1));
        }
        if (pattern.contains("?") || pattern.contains("*")) {
            return new SimplePatternImpl(pattern);
        }
        return new PatternImpl.Constant(pattern);
    }

    public static Pattern create(String pattern1, String pattern2, String ... more) throws ConfigValidationException {
        if (pattern2 == null && (more == null || more.length == 0)) {
            return Pattern.create(pattern1);
        }
        if (pattern1 == null && (more == null || more.length == 0)) {
            return Pattern.create(pattern2);
        }
        return PatternImpl.CompoundPattern.create((List<String>)ImmutableList.of((Object)pattern1, (Object)pattern2).with((Object[])more));
    }

    public static Pattern create(List<String> patterns) throws ConfigValidationException {
        if (patterns.size() == 0) {
            return PatternImpl.BLANK;
        }
        if (patterns.size() == 1) {
            return Pattern.create(patterns.get(0));
        }
        return PatternImpl.CompoundPattern.create(patterns);
    }

    public static Pattern createWithoutExclusions(Collection<String> patterns) throws ConfigValidationException {
        if (patterns.size() == 0) {
            return PatternImpl.BLANK;
        }
        if (patterns.size() == 1) {
            return Pattern.create(patterns.iterator().next());
        }
        return PatternImpl.CompoundPattern.createWithoutExclusions(patterns);
    }

    public static Pattern createUnchecked(String pattern) {
        try {
            return Pattern.create(pattern);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Pattern createUnchecked(String pattern1, String pattern2, String ... more) {
        try {
            return Pattern.create(pattern1, pattern2, more);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Pattern createUnchecked(List<String> patterns) {
        try {
            return Pattern.create(patterns);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Pattern join(Collection<Pattern> patterns) {
        if (patterns.size() == 0) {
            return PatternImpl.BLANK;
        }
        if (patterns.size() == 1) {
            return patterns.iterator().next();
        }
        return PatternImpl.CompoundPattern.join(patterns);
    }

    public static Pattern parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        if (docNode.isList()) {
            return Pattern.create(docNode.toListOfStrings());
        }
        return Pattern.create(docNode.toString());
    }

    public static boolean isConstant(String pattern) {
        if ("*".equals(pattern)) {
            return false;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return false;
        }
        return !pattern.contains("?") && !pattern.contains("*");
    }

    public static Pattern wildcard() {
        return PatternImpl.WILDCARD;
    }

    public static Pattern blank() {
        return PatternImpl.BLANK;
    }

    public boolean matches(String var1);

    public boolean matches(Iterable<String> var1);

    public ImmutableSet<String> getMatching(ImmutableSet<String> var1);

    public Iterable<String> iterateMatching(Iterable<String> var1);

    public ImmutableSet<String> getConstants();

    public ImmutableSet<String> getPatterns();

    public <E> ImmutableSet<E> getMatching(ImmutableSet<E> var1, Function<E, String> var2);

    public Pattern excluding(Pattern var1);

    public boolean isWildcard();

    public boolean isBlank();
}

